## Need to have Julia installed
## install package JuliaCall
## install.packages("JuliaCall")
## Need to install Github master of XRJulia for Julia v1.0
## install.packages("remotes")
## remotes::install_github("johnmchambers/XRJulia")

## XRJulia and JuliaCall setup
XRJulia::RJulia()
JuliaCall::julia_setup()

## Need to have package microbenchmark
## install.packages("microbenchmark")
library(microbenchmark)
M <- matrix(1, 500, 500)
rJuliaCall <- microbenchmark(JuliaCall::JuliaObject(M),
                             unit = "ms", times = 1000)
rXRJulia <- microbenchmark(XRJulia::juliaSend(M),
                           unit = "ms", times = 1000)
tab <- rbind(rXRJulia, rJuliaCall)
tab

## Markdown table can be generated by knitr::kable
knitr::kable(print(tab), format = "markdown")
